<?php
require_once "../config/database.php";
require_once "../helpers/institute.php";

header("Content-Type: application/json");

$code = $_GET['institute_code'] ?? null;
$date = $_GET['date'] ?? null;

if (!$code || !$date) {
    http_response_code(400);
    echo json_encode(["message" => "Missing parameters"]);
    exit;
}

$db = (new Database())->connect();
$instituteId = getInstituteId($db, $code);

$stmt = $db->prepare(
    "SELECT s.id, s.student_name, a.status
     FROM attendance a
     JOIN students s ON s.id = a.student_id
     WHERE a.institute_id = ? AND a.attendance_date = ?"
);
$stmt->execute([$instituteId, $date]);

$records = $stmt->fetchAll(PDO::FETCH_ASSOC);

$present = count(array_filter($records, fn($r) => $r['status'] === 'P'));

echo json_encode([
    "success" => true,
    "summary" => [
        "present" => $present,
        "absent" => count($records) - $present
    ],
    "records" => $records
]);
