<?php
require_once "../config/database.php";
require_once "../helpers/institute.php";

header("Content-Type: application/json");

$data = json_decode(file_get_contents("php://input"), true);

$code = $data['institute_code'] ?? null;
$date = $data['attendance_date'] ?? null;
$records = $data['records'] ?? [];

if (!$code || !$date || empty($records)) {
    http_response_code(400);
    echo json_encode(["message" => "Invalid request"]);
    exit;
}

$db = (new Database())->connect();
$instituteId = getInstituteId($db, $code);

if (!$instituteId) {
    http_response_code(404);
    echo json_encode(["message" => "Invalid institute"]);
    exit;
}

foreach ($records as $r) {
    $stmt = $db->prepare(
        "INSERT INTO attendance (institute_id, student_id, attendance_date, status)
         VALUES (?, ?, ?, ?)
         ON DUPLICATE KEY UPDATE status = VALUES(status)"
    );
    $stmt->execute([
        $instituteId,
        $r['student_id'],
        $date,
        $r['status']
    ]);
}

echo json_encode(["success" => true, "message" => "Attendance saved"]);
