<?php
require_once "../config/database.php";
require_once "../helpers/institute.php";

header("Content-Type: application/json");

$data = json_decode(file_get_contents("php://input"), true);

$db = (new Database())->connect();
$instituteId = getInstituteId($db, $data['institute_code']);

$stmt = $db->prepare(
    "UPDATE attendance 
     SET status = ?
     WHERE institute_id = ? 
       AND student_id = ? 
       AND attendance_date = ?"
);

$stmt->execute([
    $data['status'],
    $instituteId,
    $data['student_id'],
    $data['attendance_date']
]);

echo json_encode(["success" => true, "message" => "Attendance updated"]);
