<?php
require_once "config/database.php";
require_once "helpers/institution.php";

header("Content-Type: application/json");

$code = $_GET['code'] ?? null;
if (!$code) {
    http_response_code(400);
    echo json_encode(["message" => "Institute code required"]);
    exit;
}

$db = (new Database())->connect();
$stmt = $db->prepare("SELECT id, name FROM institutes WHERE institute_code = ?");
$stmt->execute([$code]);
$data = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$data) {
    http_response_code(404);
    echo json_encode(["message" => "Institute not found"]);
    exit;
}

echo json_encode(["success" => true, "data" => $data]);
