<?php
require_once "../config/database.php";
require_once "../helpers/institution.php";

header("Content-Type: application/json");

$code = $_GET['institute_code'] ?? null;
if (!$code) {
    http_response_code(400);
    echo json_encode(["message" => "Institute code required"]);
    exit;
}

$db = (new Database())->connect();
$instituteId = getInstituteId($db, $code);

if (!$instituteId) {
    http_response_code(404);
    echo json_encode(["message" => "Invalid institute"]);
    exit;
}

$stmt = $db->prepare(
    "SELECT id, student_name, roll_no, class 
     FROM students 
     WHERE institute_id = ? AND status = 1"
);
$stmt->execute([$instituteId]);

echo json_encode([
    "success" => true,
    "students" => $stmt->fetchAll(PDO::FETCH_ASSOC)
]);
